/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5225;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.Guis;

@Environment(value=EnvType.CLIENT)
public class GuiTextEditing {

    @Environment(value=EnvType.CLIENT)
    public static class MultiLineTextBox
    extends Guis.UiWidget
    implements class_364 {
        private static final int NORM_LINE_HEIGHT = 9;
        private static final Consumer<MultiLineTextBox> ON_CHANGE_IGNORED = tb -> {};
        private static final BiConsumer<MultiLineTextBox, Guis.Coord2d> ON_MOUSEMOVE_IGNORED = (xy, tb) -> {};
        private int frame_tick_;
        private long last_clicked_ = 0L;
        private int last_index_ = -1;
        private final class_3728 edit_;
        private String text_ = "";
        private class_327 font_;
        private int line_height_ = 9;
        private float font_scale_ = 1.0f;
        private int max_text_size_ = 1024;
        private int font_color_ = -16777216;
        private int cursor_color_ = -16777216;
        private Consumer<MultiLineTextBox> on_changed_ = ON_CHANGE_IGNORED;
        private BiConsumer<MultiLineTextBox, Guis.Coord2d> on_mouse_move_ = ON_MOUSEMOVE_IGNORED;
        @Nullable
        private DisplayCache display_cache_ = DisplayCache.EMPTY;

        public MultiLineTextBox(int x, int y, int width, int height, class_2561 title) {
            super(x, y, width, height, title);
            this.edit_ = new class_3728(this::getText, this::setText, this::getClipboard, this::setClipboard, s -> s.length() < this.max_text_size_ && this.font_.method_1713(s, width * 9 / this.line_height_) <= height * 9 / this.line_height_);
        }

        public String getValue() {
            return MultiLineTextBox.eotTrimmed(this.text_);
        }

        public MultiLineTextBox setValue(String text) {
            if (text.length() > this.getMaxLength()) {
                text = text.substring(0, this.getMaxLength());
            }
            if (!this.text_.equals(text)) {
                if (this.edit_ == null) {
                    this.text_ = MultiLineTextBox.eotTrimmed(text);
                } else {
                    boolean to_end = this.text_.isEmpty();
                    int cur = this.edit_.method_16201();
                    int sel = this.edit_.method_16203();
                    this.edit_.method_27563();
                    this.edit_.method_16197(MultiLineTextBox.eotTrimmed(text));
                    if (to_end) {
                        sel = cur = this.text_.length();
                    }
                    this.edit_.method_35731(sel);
                    this.edit_.method_35730(cur);
                }
                this.clearDisplayCache();
            }
            return this;
        }

        public int getMaxLength() {
            return this.max_text_size_;
        }

        public MultiLineTextBox setMaxLength(int size) {
            this.max_text_size_ = class_3532.method_15340((int)size, (int)2, (int)1024);
            if (this.text_.length() > this.max_text_size_) {
                this.text_ = MultiLineTextBox.eotTrimmed(this.text_.substring(0, this.max_text_size_));
                this.on_changed_.accept(this);
            }
            return this;
        }

        public class_327 getFont() {
            return this.font_;
        }

        public MultiLineTextBox setFont(class_327 fnt) {
            this.font_ = fnt;
            return this;
        }

        public int getFontColor() {
            return this.font_color_;
        }

        public MultiLineTextBox setFontColor(int color) {
            this.font_color_ = color | 0xFF000000;
            return this;
        }

        public int getCursorColor() {
            return this.cursor_color_;
        }

        public MultiLineTextBox setCursorColor(int color) {
            this.cursor_color_ = color | 0xFF000000;
            return this;
        }

        public int getLineHeight() {
            return this.line_height_;
        }

        public MultiLineTextBox setLineHeight(int h) {
            this.line_height_ = class_3532.method_15340((int)h, (int)6, (int)9);
            this.font_scale_ = (float)this.line_height_ / 9.0f;
            return this;
        }

        public MultiLineTextBox onValueChanged(Consumer<MultiLineTextBox> cb) {
            this.on_changed_ = cb;
            return this;
        }

        public MultiLineTextBox onMouseMove(BiConsumer<MultiLineTextBox, Guis.Coord2d> cb) {
            this.on_mouse_move_ = cb;
            return this;
        }

        public int getIndexUnderMouse(double mouseX, double mouseY) {
            return this.font_ == null ? 0 : this.getDisplayCache().getIndexAtPosition(this.font_, this.screenCoordinates(Guis.Coord2d.of((int)mouseX, (int)mouseY), false));
        }

        public Guis.Coord2d getCoordinatesAtIndex(int textIndex) {
            if (this.font_ == null) {
                return Guis.Coord2d.ORIGIN;
            }
            int lindex = MultiLineTextBox.findLineFromPos(this.getDisplayCache().lineStarts, textIndex = class_3532.method_15340((int)textIndex, (int)0, (int)this.getDisplayCache().fullText.length()));
            if (lindex < 0 || lindex >= this.getDisplayCache().lineStarts.length) {
                return Guis.Coord2d.ORIGIN;
            }
            LineInfo li = this.getDisplayCache().lines[lindex];
            textIndex -= this.getDisplayCache().lineStarts[lindex];
            textIndex = class_3532.method_15340((int)textIndex, (int)0, (int)li.contents.length());
            int ox = (int)this.font_.method_27527().method_27482(li.contents.substring(0, textIndex));
            int oy = this.getDisplayCache().lines[0].y;
            return Guis.Coord2d.of(li.x + ox * this.line_height_ / 9, oy + (li.y - oy) * this.line_height_ / 9);
        }

        public String getWordAtPosition(Guis.Coord2d xy) {
            return "";
        }

        @Override
        public MultiLineTextBox init(class_437 parent) {
            return this.init(parent, Guis.Coord2d.of(this.method_46426(), this.method_46427()));
        }

        @Override
        public MultiLineTextBox init(class_437 parent, Guis.Coord2d position) {
            super.init(parent, position);
            this.font_ = class_310.method_1551().field_1772;
            this.font_color_ = -16777216;
            this.cursor_color_ = -16777216;
            this.clearDisplayCache();
            return this;
        }

        public boolean method_25402(double x, double y, int button) {
            if (!this.field_22763 || !this.field_22764 || x < (double)this.method_46426() || y < (double)this.method_46427() || x > (double)(this.method_46426() + this.field_22758) || y > (double)(this.method_46427() + this.field_22759)) {
                return false;
            }
            if (button != 0) {
                return true;
            }
            Guis.Coord2d sc = this.screenCoordinates(Guis.Coord2d.of((int)x, (int)y), false);
            int index = this.getDisplayCache().getIndexAtPosition(this.font_, Guis.Coord2d.of(sc.x * 9 / this.line_height_, sc.y * 9 / this.line_height_));
            if (index >= 0) {
                if (index == this.last_index_ && class_156.method_658() - this.last_clicked_ < 250L) {
                    if (this.edit_.method_27568()) {
                        this.edit_.method_27563();
                    } else {
                        this.edit_.method_27548(class_5225.method_27483((String)this.getText(), (int)-1, (int)index, (boolean)false), class_5225.method_27483((String)this.getText(), (int)1, (int)index, (boolean)false));
                    }
                } else {
                    this.edit_.method_27560(index, class_437.method_25442());
                }
                this.clearDisplayCache();
            }
            this.last_index_ = index;
            this.last_clicked_ = index;
            if (this.method_25370()) {
                this.method_25365(true);
            }
            return true;
        }

        public boolean method_25403(double x, double y, int button, double dx, double dy) {
            if (super.method_25403(x, y, button, dx, dy) || button != 0) {
                return true;
            }
            if (!this.field_22763 || !this.field_22764) {
                return false;
            }
            Guis.Coord2d sc = this.screenCoordinates(Guis.Coord2d.of((int)x, (int)y), false);
            this.edit_.method_27560(this.getDisplayCache().getIndexAtPosition(this.font_, Guis.Coord2d.of(sc.x * 9 / this.line_height_, sc.y * 9 / this.line_height_)), true);
            this.clearDisplayCache();
            return true;
        }

        public boolean method_25400(char key, int code) {
            if (super.method_25400(key, code)) {
                return true;
            }
            if (!this.field_22763 || !this.field_22764) {
                return false;
            }
            if (!class_3544.method_57175((char)key)) {
                return false;
            }
            this.edit_.method_16197(Character.toString(key));
            this.clearDisplayCache();
            this.on_changed_.accept(this);
            return true;
        }

        public boolean method_25404(int key, int x, int y) {
            if (super.method_25404(key, x, y)) {
                return true;
            }
            if (!this.field_22763 || !this.field_22764) {
                return false;
            }
            String text_before = this.text_;
            if (!this.specialKeyMatched(key)) {
                return this.method_25370();
            }
            this.clearDisplayCache();
            if (key == 257 && !this.edit_.method_27568() && this.edit_.method_16201() < this.text_.length() - 2) {
                int cp = this.edit_.method_16201();
                this.edit_.method_27563();
                this.edit_.method_16197(MultiLineTextBox.eotTrimmed(this.text_));
                this.edit_.method_35731(cp);
                this.edit_.method_27560(cp, false);
            }
            if (!text_before.equals(this.text_)) {
                this.on_changed_.accept(this);
            }
            return true;
        }

        @Override
        protected void method_48579(class_332 gg, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764) {
                return;
            }
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ox = (int)((double)this.method_46426() * (1.0 - (double)this.font_scale_));
            int oy = (int)((double)this.method_46427() * (1.0 - (double)this.font_scale_));
            class_4587 mxs = gg.method_51448();
            mxs.method_22903();
            mxs.method_46416((float)ox, (float)oy, 0.0f);
            mxs.method_22905(this.font_scale_, this.font_scale_, this.font_scale_);
            DisplayCache cache = this.getDisplayCache();
            for (LineInfo li : cache.lines) {
                gg.method_27535(this.font_, li.asComponent, li.x, li.y, this.font_color_);
            }
            this.renderCursor(gg, cache.cursor, cache.cursorAtEnd);
            this.renderHighlight(gg, cache.selection);
            Guis.Coord2d xy = this.getMousePosition();
            if (xy.x >= 0 && xy.y >= 0 && xy.x < this.field_22758 && xy.y < this.field_22759) {
                this.on_mouse_move_.accept(this, this.getMousePosition());
            }
            mxs.method_22909();
        }

        private static String eotTrimmed(String text) {
            return text.replaceAll("\\s+$", "\n");
        }

        private String getText() {
            return this.text_;
        }

        private void setText(String text) {
            this.text_ = text;
            this.clearDisplayCache();
        }

        private void setClipboard(String text) {
            if (class_310.method_1551() != null) {
                class_3728.method_27551((class_310)class_310.method_1551(), (String)MultiLineTextBox.eotTrimmed(text));
            }
        }

        private String getClipboard() {
            return class_310.method_1551() != null ? MultiLineTextBox.eotTrimmed(class_3728.method_27556((class_310)class_310.method_1551())) : "";
        }

        private boolean specialKeyMatched(int key) {
            if (class_437.method_25439((int)key)) {
                this.edit_.method_27563();
                return true;
            }
            if (class_437.method_25438((int)key)) {
                this.edit_.method_27559();
                return true;
            }
            if (class_437.method_25437((int)key)) {
                this.edit_.method_27554();
                return true;
            }
            if (class_437.method_25436((int)key)) {
                this.edit_.method_27547();
                return true;
            }
            switch (key) {
                case 257: 
                case 335: {
                    this.edit_.method_16197("\n");
                    return true;
                }
                case 259: {
                    this.edit_.method_27564(-1);
                    return true;
                }
                case 261: {
                    this.edit_.method_27564(1);
                    return true;
                }
                case 262: {
                    this.edit_.method_27549(1, class_437.method_25442());
                    return true;
                }
                case 263: {
                    this.edit_.method_27549(-1, class_437.method_25442());
                    return true;
                }
                case 264: {
                    this.changeLine(1);
                    return true;
                }
                case 265: {
                    this.changeLine(-1);
                    return true;
                }
                case 266: {
                    this.edit_.method_27560(0, class_437.method_25442());
                    return true;
                }
                case 267: {
                    this.edit_.method_27560(this.text_.length(), class_437.method_25442());
                    return true;
                }
                case 268: {
                    this.edit_.method_27560(this.getDisplayCache().findLineStart(this.edit_.method_16201()), class_437.method_25442());
                    return true;
                }
                case 269: {
                    this.edit_.method_27560(this.getDisplayCache().findLineEnd(this.edit_.method_16201()), class_437.method_25442());
                    return true;
                }
            }
            return false;
        }

        private void changeLine(int incr) {
            this.edit_.method_27560(this.getDisplayCache().changeLine(this.edit_.method_16201(), incr), class_437.method_25442());
        }

        private void renderCursor(class_332 gg, Guis.Coord2d pos, boolean at_end) {
            if (!this.field_22763 || !this.field_22764) {
                this.frame_tick_ = 0;
            }
            if ((++this.frame_tick_ & 0x3F) < 32) {
                return;
            }
            pos = this.screenCoordinates(pos, true);
            if (!at_end) {
                gg.method_25294(pos.x, pos.y - 1, pos.x + 1, pos.y + 9, this.cursor_color_);
            } else {
                gg.method_25303(this.font_, "_", pos.x, pos.y, this.cursor_color_);
            }
        }

        private void renderHighlight(class_332 gg, class_768[] line_rects) {
            int fill_color = 0x339999FF;
            int first_y_offset_px = -1;
            for (class_768 rc : line_rects) {
                int x = rc.method_3321() - this.method_46426();
                int y = rc.method_3322() - this.method_46427();
                Guis.Coord2d pos0 = this.screenCoordinates(Guis.Coord2d.of(x, y), true);
                Guis.Coord2d pos1 = this.screenCoordinates(Guis.Coord2d.of(x + rc.method_3319(), y + rc.method_3320()), true);
                gg.method_25294(pos0.x - 1, pos0.y + first_y_offset_px, pos1.x - 1, pos1.y + first_y_offset_px, 0x339999FF);
                first_y_offset_px = 0;
            }
        }

        private DisplayCache getDisplayCache() {
            if (this.display_cache_ == null) {
                this.display_cache_ = this.rebuildDisplayCache();
            }
            return this.display_cache_;
        }

        private void clearDisplayCache() {
            this.display_cache_ = null;
        }

        private DisplayCache rebuildDisplayCache() {
            Guis.Coord2d ppos;
            boolean cur_at_eos;
            String full_text = this.getText();
            if (full_text.isEmpty()) {
                return DisplayCache.EMPTY;
            }
            int cur_pos = this.edit_.method_16201();
            int sel_pos = this.edit_.method_16203();
            IntArrayList lsp = new IntArrayList();
            ArrayList line_infos = Lists.newArrayList();
            MutableInt line_no = new MutableInt();
            MutableBoolean line_terminated = new MutableBoolean();
            class_5225 ssp = this.font_.method_27527();
            ssp.method_27485(full_text, this.field_22758 * 9 / this.line_height_, class_2583.field_24360, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$3(full_text, line_terminated, (IntList)lsp, line_no, line_infos, arg_0, arg_1, arg_2));
            int[] line_starts = lsp.toIntArray();
            boolean bl = cur_at_eos = cur_pos == full_text.length();
            if (cur_at_eos && line_terminated.isTrue()) {
                ppos = new Guis.Coord2d(0, line_infos.size() * 9);
            } else {
                int lno = MultiLineTextBox.findLineFromPos(line_starts, cur_pos);
                int lpx = this.font_.method_1727(full_text.substring(line_starts[lno], cur_pos));
                ppos = new Guis.Coord2d(lpx, lno * 9);
            }
            ArrayList selection_blocks = Lists.newArrayList();
            if (cur_pos != sel_pos) {
                int k1;
                int l2 = Math.min(cur_pos, sel_pos);
                int i1 = Math.max(cur_pos, sel_pos);
                int j1 = MultiLineTextBox.findLineFromPos(line_starts, l2);
                if (j1 == (k1 = MultiLineTextBox.findLineFromPos(line_starts, i1))) {
                    int l1 = j1 * 9;
                    int i2 = line_starts[j1];
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, l2, i1, l1, i2));
                } else {
                    int i3 = j1 + 1 > line_starts.length ? full_text.length() : line_starts[j1 + 1];
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, l2, i3, j1 * 9, line_starts[j1]));
                    for (int j3 = j1 + 1; j3 < k1; ++j3) {
                        int j2 = j3 * 9;
                        String s1 = full_text.substring(line_starts[j3], line_starts[j3 + 1]);
                        int k2 = (int)ssp.method_27482(s1);
                        selection_blocks.add(this.createSelection(new Guis.Coord2d(0, j2), new Guis.Coord2d(k2, j2 + 9)));
                    }
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, line_starts[k1], i1, k1 * 9, line_starts[k1]));
                }
            }
            return new DisplayCache(full_text, ppos, cur_at_eos, line_starts, line_infos.toArray(new LineInfo[0]), selection_blocks.toArray(new class_768[0]));
        }

        private static int findLineFromPos(int[] line_starts, int cursor_pos) {
            int i = Arrays.binarySearch(line_starts, cursor_pos);
            return i < 0 ? -(i + 2) : i;
        }

        private class_768 createPartialLineSelection(String text, class_5225 ssp, int spos, int epos, int liney, int line_start_pos) {
            String s0 = text.substring(line_start_pos, spos);
            String s1 = text.substring(line_start_pos, epos).replaceAll("[\\r\\n]+$", "");
            return this.createSelection(new Guis.Coord2d((int)ssp.method_27482(s0), liney), new Guis.Coord2d((int)ssp.method_27482(s1), liney + 9));
        }

        private class_768 createSelection(Guis.Coord2d pos1, Guis.Coord2d pos2) {
            Guis.Coord2d cd1 = this.screenCoordinates(pos1, true);
            Guis.Coord2d cd2 = this.screenCoordinates(pos2, true);
            int x0 = Math.min(cd1.x, cd2.x);
            int x1 = Math.max(cd1.x, cd2.x);
            int y0 = Math.min(cd1.y, cd2.y);
            int y1 = Math.max(cd1.y, cd2.y);
            return new class_768(x0, y0, x1 - x0, y1 - y0);
        }

        private /* synthetic */ void lambda$rebuildDisplayCache$3(String full_text, MutableBoolean line_terminated, IntList lsp, MutableInt line_no, List line_infos, class_2583 text, int spos, int epos) {
            String full_line = full_text.substring(spos, epos);
            line_terminated.setValue(full_line.endsWith("\n"));
            String line = StringUtils.stripEnd((String)full_line, (String)" \n");
            lsp.add(spos);
            Guis.Coord2d pxy = this.screenCoordinates(new Guis.Coord2d(0, line_no.getAndIncrement() * 9), true);
            line_infos.add(new LineInfo(text, line, pxy.x, pxy.y));
        }

        @Environment(value=EnvType.CLIENT)
        static class DisplayCache {
            static final DisplayCache EMPTY = new DisplayCache("", new Guis.Coord2d(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
            private final String fullText;
            final Guis.Coord2d cursor;
            final boolean cursorAtEnd;
            private final int[] lineStarts;
            final LineInfo[] lines;
            final class_768[] selection;

            public DisplayCache(String text, Guis.Coord2d cur, boolean at_end, int[] line_starts, LineInfo[] line_data, class_768[] sel) {
                this.fullText = text;
                this.cursor = cur;
                this.cursorAtEnd = at_end;
                this.lineStarts = line_starts;
                this.lines = line_data;
                this.selection = sel;
            }

            public int getIndexAtPosition(class_327 font, Guis.Coord2d pos) {
                int i = pos.y / 9;
                if (i < 0) {
                    return 0;
                }
                if (i >= this.lines.length) {
                    return this.fullText.length();
                }
                return this.lineStarts[i] + font.method_27527().method_27484(this.lines[i].contents, pos.x, this.lines[i].style);
            }

            public int changeLine(int cursor_pos, int length) {
                int k;
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                int j = i + length;
                if (0 <= j && j < this.lineStarts.length) {
                    int l = cursor_pos - this.lineStarts[i];
                    int i1 = this.lines[j].contents.length();
                    k = this.lineStarts[j] + Math.min(l, i1);
                } else {
                    k = cursor_pos;
                }
                return k;
            }

            public int findLineStart(int cursor_pos) {
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                return this.lineStarts[i];
            }

            public int findLineEnd(int cursor_pos) {
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                return this.lineStarts[i] + this.lines[i].contents.length();
            }
        }

        @Environment(value=EnvType.CLIENT)
        static class LineInfo {
            final class_2583 style;
            final String contents;
            final class_2561 asComponent;
            final int x;
            final int y;

            public LineInfo(class_2583 fs, String s, int x0, int y0) {
                this.style = fs;
                this.contents = s;
                this.x = x0;
                this.y = y0;
                this.asComponent = class_2561.method_43470((String)this.contents).method_10862(this.style);
            }
        }
    }
}

